/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.pngwalk;

import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.autoplot.ApplicationModel;
import org.autoplot.AutoplotUtil;
import org.autoplot.ScriptContext;
import org.autoplot.ScriptContext2023;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.URISplit;
import org.autoplot.dom.Application;
import org.autoplot.dom.Plot;
import org.autoplot.dom.PlotElement;
import org.autoplot.jythonsupport.Util;
import org.autoplot.pngwalk.CreatePngWalkDialog;
import org.autoplot.pngwalk.ImageResize;
import org.autoplot.pngwalk.PngWalkTool;
import org.autoplot.state.StatePersistence;
import org.das2.components.DasProgressPanel;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.DatumUtil;
import org.das2.datum.InconvertibleUnitsException;
import org.das2.datum.TimeParser;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.datum.format.FormatStringFormatter;
import org.das2.qds.DataSetOps;
import org.das2.qds.DataSetUtil;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.ops.Ops;
import org.das2.util.ArgumentList;
import org.das2.util.DasPNGEncoder;
import org.das2.util.ExceptionHandler;
import org.das2.util.FileUtil;
import org.das2.util.LoggerManager;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;

public class CreatePngWalk {
    private static final Logger logger = LoggerManager.getLogger((String)"autoplot.pngwalk");
    private static int returnCode1 = 0;

    private static String[] getListOfTimes(Params params, List<String> warnings) throws IllegalArgumentException, ParseException {
        String[] times;
        if (params.useBatchUri) {
            try {
                String uri = params.batchUri;
                QDataSet timesds = Util.getDataSet((String)uri);
                times = new String[timesds.length()];
                if (params.batchUriName.equals("")) {
                    if (!UnitsUtil.isTimeLocation((Units)SemanticOps.getUnits((QDataSet)timesds))) {
                        if ((QDataSet)timesds.property("DEPEND_0") != null) {
                            timesds = (QDataSet)timesds.property("DEPEND_0");
                        } else if (SemanticOps.isBundle((QDataSet)timesds)) {
                            timesds = Ops.bundle((QDataSet)DataSetOps.unbundle((QDataSet)timesds, (int)0), (QDataSet)DataSetOps.unbundle((QDataSet)timesds, (int)1));
                        } else {
                            throw new IllegalArgumentException("expected events list URI");
                        }
                    }
                    if (timesds.rank() != 2) {
                        timesds = Ops.createEvents((QDataSet)timesds);
                    }
                    if (timesds.rank() != 2) {
                        throw new IllegalArgumentException("expected bins dataset for times");
                    }
                    TimeParser tp = TimeParser.create((String)params.timeFormat);
                    for (int i = 0; i < times.length; ++i) {
                        times[i] = tp.format(DataSetUtil.asDatumRange((QDataSet)timesds.slice(i))) + ": " + DataSetUtil.asDatumRange((QDataSet)timesds.slice(i)).toString();
                    }
                }
                timesds = Ops.createEvents((QDataSet)timesds);
                Units tu = (Units)((QDataSet)timesds.property("BUNDLE_1")).property("UNITS", 0);
                Units eu = (Units)((QDataSet)timesds.property("BUNDLE_1")).property("UNITS", 3);
                if (uri.endsWith(".txt")) {
                    logger.fine("reading events file to preserve identity of orbits.");
                    for (int i = 0; i < times.length; ++i) {
                        String s;
                        String s1 = eu.createDatum(timesds.slice(i).value(3)).toString();
                        times[i] = s = s1 + ": orbit:" + uri + ":" + s1;
                    }
                }
                logger.fine("reading events file as start/stop times.");
                for (int i = 0; i < times.length; ++i) {
                    times[i] = eu.createDatum(timesds.slice(i).value(3)).toString() + ": " + DatumRange.newDatumRange((double)timesds.slice(i).value(0), (double)timesds.slice(i).value(1), (Units)tu);
                }
            }
            catch (Exception ex) {
                if (ex instanceof IllegalArgumentException) {
                    throw (IllegalArgumentException)ex;
                }
                throw new IllegalArgumentException(ex);
            }
        } else {
            times = ScriptContext.generateTimeRanges(params.timeFormat, params.timeRangeStr);
        }
        return times;
    }

    private static boolean isDataVisible(Application dom2) {
        DatumRange tr = dom2.getTimeRange();
        boolean dataVisible = false;
        for (PlotElement pe : dom2.getPlotElements()) {
            QDataSet dsout = pe.getController().getDataSet();
            if (dsout == null) continue;
            try {
                dsout = SemanticOps.trim((QDataSet)dsout, (DatumRange)tr, null);
            }
            catch (InconvertibleUnitsException inconvertibleUnitsException) {
                // empty catch block
            }
            if (dsout.length() == 0) continue;
            dataVisible = true;
            break;
        }
        return dataVisible;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BufferedImage myWriteToPng(String filename, Application ldom, int width, int height) throws InterruptedException, FileNotFoundException, IOException {
        BufferedImage image = null;
        try (OutputStream out = null;){
            File outf = new File(filename);
            File parentf = outf.getParentFile();
            if (parentf != null && !parentf.exists() && !parentf.mkdirs()) {
                throw new IllegalArgumentException("failed to make directories " + parentf);
            }
            out = new FileOutputStream(filename);
            image = ldom.getCanvases(0).getController().getDasCanvas().getImage(width, height);
            DasPNGEncoder encoder = new DasPNGEncoder();
            encoder.addText("Creation Time", new Date().toString());
            encoder.addText("Software", "Autoplot");
            encoder.addText("plotInfo", ldom.getCanvases(0).getController().getDasCanvas().getImageMetadata());
            encoder.write(image, out);
        }
        if (image == null) {
            throw new IllegalArgumentException("image not assigned, this shouldn't happen.");
        }
        return image;
    }

    public static int doBatch(String[] times, Application readOnlyDom, Params params, ProgressMonitor mon) throws IOException, InterruptedException {
        return CreatePngWalk.doBatch(Arrays.asList(times).iterator(), times.length, readOnlyDom, params, mon);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int doBatch(Iterator<String> times, int size, Application readOnlyDom, Params params, ProgressMonitor mon) throws IOException, InterruptedException {
        File thumbsFolder;
        File f;
        File outputFolder;
        ArrayList<String> pngFilenameArrayThumbs = new ArrayList<String>();
        ArrayList<String> pngFilenameArrayBig = new ArrayList<String>();
        ArrayList<String> timeLabels = new ArrayList<String>();
        int returnCodeAll = 10;
        logger.log(Level.CONFIG, "CreatePngWalk.doBatch with params {0}", params);
        if (!params.outputFolder.endsWith("/") && !params.outputFolder.endsWith("\\")) {
            params.outputFolder = params.outputFolder + "/";
        }
        if (!(outputFolder = new File(params.outputFolder)).exists() && !outputFolder.mkdirs()) {
            throw new IOException("failed mkdirs: " + outputFolder);
        }
        if (!outputFolder.canWrite()) {
            throw new IOException("unable to write to folder " + outputFolder);
        }
        if (params.update && !(f = new File(outputFolder, params.product + ".lock")).exists()) {
            logger.info("creating lock file so multiple processes can work on pngwalk.");
            if (!f.createNewFile()) {
                logger.info("failed to create lock file, some work may be redone.");
            }
        }
        if (params.createThumbs) {
            thumbsFolder = new File(params.outputFolder, "thumbs400/");
            if (!thumbsFolder.exists() && !thumbsFolder.mkdirs()) {
                throw new IOException("failed mkdirs: " + thumbsFolder);
            }
            if (!thumbsFolder.canWrite()) {
                throw new IOException("unable to write to folder " + thumbsFolder);
            }
        } else {
            thumbsFolder = new File(params.outputFolder, "thumbs400/");
            if (thumbsFolder.exists()) {
                System.err.println("warning: thumbs folder already exists!");
            }
        }
        int n = size;
        mon.setTaskSize((long)n);
        mon.started();
        try {
            int h0;
            int w0;
            Application dom2;
            ApplicationModel appmodel;
            mon.setProgressMessage("initializing child application");
            TimeParser tp = TimeParser.create((String)params.timeFormat);
            Application dom = (Application)readOnlyDom.copy();
            dom.getOptions().syncToAll(readOnlyDom.getOptions(), new ArrayList<String>());
            if (!times.hasNext()) {
                throw new IllegalArgumentException("there must be at least one time");
            }
            String atime = times.next();
            try {
                DatumRange tr1;
                int ic = atime.indexOf(": ");
                String exactTime = ic > -1 ? atime.substring(ic + 2) : atime;
                if (params.useBatchUri) {
                    tr1 = DatumRangeUtil.parseTimeRange((String)exactTime);
                    dom.setTimeRange(tr1);
                } else {
                    tr1 = tp.parse(exactTime).getTimeRange();
                    dom.setTimeRange(tr1);
                }
            }
            catch (ParseException ex) {
                throw new RuntimeException(ex);
            }
            if (params.runOnCopy) {
                appmodel = new ApplicationModel();
                appmodel.addDasPeersToAppAndWait();
                dom2 = appmodel.getDocumentModel();
                mon.setProgressMessage("synchronize to this application");
                dom2.getCanvases(0).setHeight(dom.getCanvases(0).getHeight());
                dom2.getCanvases(0).setWidth(dom.getCanvases(0).getWidth());
                w0 = dom2.getCanvases(0).getWidth();
                h0 = dom2.getCanvases(0).getHeight();
                dom2.getCanvases(0).getController().getDasCanvas().setSize(w0, h0);
                dom2.getCanvases(0).getController().getDasCanvas().revalidate();
                dom2.syncTo(dom, Arrays.asList("id"));
                dom2.getController().waitUntilIdle();
                dom2.syncTo(dom, Arrays.asList("id"));
                dom2.getOptions().syncToAll(readOnlyDom.getOptions(), new ArrayList<String>());
            } else {
                dom2 = readOnlyDom;
                w0 = dom2.getCanvases(0).getWidth();
                h0 = dom2.getCanvases(0).getHeight();
            }
            appmodel = dom2.getController().getApplicationModel();
            int thumbSize = 400;
            int thumbH = 0;
            int thumbW = 0;
            if (params.createThumbs) {
                double aspect = 1.0 * (double)w0 / (double)h0;
                thumbH = (int)Math.sqrt(Math.pow(thumbSize, 2.0) / (aspect * aspect + 1.0));
                thumbW = (int)((double)thumbH * aspect);
            }
            if (params.writeVap) {
                mon.setProgressMessage("write " + params.product + ".vap");
                logger.log(Level.FINE, "write {0}.vap", params.product);
                StatePersistence.saveState(new File(outputFolder, params.product + ".vap"), (Object)dom2, "");
            }
            String vap = new File(outputFolder, params.product + ".vap").toString();
            StringBuilder build = new StringBuilder();
            build.append(String.format("JAVA -cp autoplot.jar org.autoplot.pngwalk.CreatePngWalk ", new Object[0]));
            try (PrintWriter ff = new PrintWriter(new FileWriter(new File(outputFolder, params.product + ".pngwalk")));){
                build.append("--vap=").append(vap).append(" ");
                build.append("--outputFolder=").append(params.outputFolder).append(" ");
                ff.println("# set the following line to the location of the pngwalk");
                ff.println("baseurl=.");
                ff.println("product=" + params.product);
                build.append("--product=").append(params.product).append(" ");
                ff.println("timeFormat=" + params.timeFormat);
                build.append("--timeFormat='").append(params.timeFormat).append("' ");
                if (!params.useBatchUri) {
                    ff.println("timeRange=" + params.timeRangeStr);
                    build.append("--timeRange='").append(params.timeRangeStr).append("' ");
                }
                if (params.batchUriName.equals("$o")) {
                    ff.println("# the filePattern may need editing, depending on extension and subdirectories.");
                    ff.println("filePattern=*.png");
                }
                if (params.useBatchUri) {
                    if (params.batchUri != null && !params.batchUri.equals("")) {
                        ff.println("batchUri=" + params.batchUri);
                        build.append("--batchUri=").append(params.batchUri).append(" ");
                    }
                    if (!params.batchUriName.equals("")) {
                        ff.println("batchUriName=" + params.batchUri);
                        build.append("--batchUriName=").append(params.batchUri).append(" ");
                    }
                }
                if (params.rescalex != null && !params.rescalex.equals("0%,100%")) {
                    ff.println("rescalex=" + params.rescalex);
                    build.append("--rescalex=").append(params.rescalex).append(" ");
                }
                if (params.autorange) {
                    ff.println("autorange=" + params.autorange);
                    build.append("--autorange=").append(params.autorange).append(" ");
                }
                if (params.autorangeFlags) {
                    ff.println("autorangeFlags=" + params.autorangeFlags);
                    build.append("--autorangeFlags=").append(params.autorangeFlags).append(" ");
                }
                if (params.version != null && params.version.trim().length() > 0) {
                    ff.println("version=" + params.version);
                    build.append("--version=").append(params.version);
                }
                if (!params.outputFormat.equals("png")) {
                    ff.println("outputFormat=" + params.outputFormat);
                    build.append("--outputFormat=").append(params.outputFormat);
                }
            }
            if (!(mon instanceof NullProgressMonitor)) {
                System.err.println(build.toString());
            }
            dom2.getController().waitUntilIdle();
            mon.setProgressMessage("making images");
            LinkedList<Long> t0s = new LinkedList<Long>();
            int count = 0;
            appmodel.setExceptionHandler(new ExceptionHandler(){

                public void handle(Throwable t) {
                    logger.log(Level.WARNING, null, t);
                    returnCode1 = 11;
                }

                public void handleUncaught(Throwable t) {
                    logger.log(Level.WARNING, null, t);
                    returnCode1 = 12;
                }
            });
            boolean firstTime = true;
            int countRecent = 20;
            do {
                t0s.add(System.currentTimeMillis());
                while (t0s.size() > countRecent) {
                    t0s.remove(0);
                }
                if (!firstTime) {
                    atime = times.next();
                }
                returnCode1 = 0;
                int ic = atime.indexOf(": ");
                String exactTime = null;
                if (ic > -1) {
                    exactTime = atime.substring(ic + 2);
                    atime = atime.substring(0, ic);
                }
                String filename = CreatePngWalk.getFilename(params, "", atime);
                ++count;
                if (mon.isCancelled()) break;
                mon.setTaskProgress((long)count);
                FileChannel fileChannel = null;
                File outTemp = new File(filename + ".lock");
                if (params.update) {
                    File out;
                    File lockFile = new File(params.outputFolder + params.product + ".lock");
                    FileLock lock = null;
                    if (lockFile.exists()) {
                        Path p = Paths.get(lockFile.toURI());
                        fileChannel = FileChannel.open(p, StandardOpenOption.WRITE);
                        lock = fileChannel.lock();
                    }
                    if ((out = new File(filename)).exists() || outTemp.exists()) {
                        mon.setProgressMessage(String.format("skipping %s", filename));
                        logger.log(Level.FINE, String.format("skipping %s", filename));
                        if (lock != null) {
                            lock.release();
                            fileChannel.close();
                        }
                        if (!firstTime) continue;
                        dom2.getOptions().setAutolayout(false);
                        appmodel.waitUntilIdle();
                        firstTime = false;
                        continue;
                    }
                    if (!outTemp.createNewFile()) {
                        logger.log(Level.WARNING, "unable to make new file: {0}", outTemp);
                    }
                    if (lock != null) {
                        lock.release();
                        fileChannel.close();
                    }
                } else if (!outTemp.createNewFile()) {
                    logger.log(Level.WARNING, "unable to make new file: {0}", outTemp);
                }
                String currentTimeLabel = "error";
                try {
                    String rescalex;
                    DatumRange dr = exactTime == null ? tp.parse(atime).getTimeRange() : DatumRangeUtil.parseTimeRange((String)exactTime);
                    if (params.rescalex != null && (rescalex = params.rescalex.trim()).length() > 0 && !params.rescalex.equals("0%,100%")) {
                        dr = DatumRangeUtil.rescale((DatumRange)dr, (String)params.rescalex);
                    }
                    currentTimeLabel = dr.toString();
                    if (!dom2.getTimeRange().equals((Object)dr)) {
                        dom2.setTimeRange(dr);
                    }
                }
                catch (ParseException ex) {
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                }
                mon.setProgressMessage(String.format("write %s", filename));
                logger.log(Level.FINE, String.format("write %s", filename));
                appmodel.waitUntilIdle();
                if (params.autorange) {
                    if (params.autorangeFlags) {
                        for (Plot p : dom2.getPlots()) {
                            if (p.getYaxis().isAutoRange()) {
                                AutoplotUtil.resetZoomY(dom2, p);
                            }
                            if (!p.getZaxis().isAutoRange()) continue;
                            AutoplotUtil.resetZoomZ(dom2, p);
                        }
                    } else {
                        for (Plot p : dom2.getPlots()) {
                            dom2.getController().setPlot(p);
                            AutoplotUtil.resetZoomY(dom2);
                            AutoplotUtil.resetZoomZ(dom2);
                        }
                    }
                }
                appmodel.waitUntilIdle();
                if (firstTime) {
                    dom2.getOptions().setAutolayout(false);
                    appmodel.waitUntilIdle();
                    firstTime = false;
                }
                if (params.removeNoData && !CreatePngWalk.isDataVisible(dom2)) {
                    logger.log(Level.FINE, "No data found for \"{0}\"", atime);
                    if (outTemp.delete()) continue;
                    logger.log(Level.WARNING, "unable to delete {0}", outTemp);
                    continue;
                }
                pngFilenameArrayThumbs.add(CreatePngWalk.getRelativeFilename(params, "thumbs100", atime));
                pngFilenameArrayBig.add(CreatePngWalk.getRelativeFilename(params, "", atime));
                timeLabels.add(currentTimeLabel);
                BufferedImage image = null;
                try {
                    if (params.outputFormat.equals("png")) {
                        image = CreatePngWalk.myWriteToPng(filename, dom2, w0, h0);
                    } else {
                        dom2.getCanvases(0).getController().getDasCanvas().writeToPDF(filename);
                    }
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, "unable to write file " + filename, ex);
                    throw new IOException("unable to write file " + filename, ex);
                }
                if (returnCode1 == 0) {
                    returnCodeAll = 0;
                } else if (returnCodeAll == 10) {
                    returnCodeAll = returnCode1;
                }
                if (params.createThumbs && params.outputFormat.equals("png")) {
                    BufferedImage thumb400 = ImageResize.getScaledInstance(image, thumbW, thumbH, RenderingHints.VALUE_INTERPOLATION_BILINEAR, true);
                    File outf = new File(CreatePngWalk.getFilename(params, "thumbs400", atime));
                    File parentf = outf.getParentFile();
                    if (parentf != null && !parentf.exists() && !parentf.mkdirs()) {
                        throw new IllegalArgumentException("failed to make directories: " + parentf);
                    }
                    if (!ImageIO.write((RenderedImage)thumb400, "png", outf)) {
                        throw new IllegalArgumentException("no appropriate writer is found");
                    }
                    BufferedImage thumb100 = ImageResize.getScaledInstance(thumb400, thumbW / 4, thumbH / 4, RenderingHints.VALUE_INTERPOLATION_BILINEAR, true);
                    outf = new File(CreatePngWalk.getFilename(params, "thumbs100", atime));
                    parentf = outf.getParentFile();
                    if (parentf != null && !parentf.exists() && !parentf.mkdirs()) {
                        throw new IllegalArgumentException("failed to make directories: " + parentf);
                    }
                    if (!ImageIO.write((RenderedImage)thumb100, "png", outf)) {
                        throw new IllegalArgumentException("no appropriate writer is found");
                    }
                }
                double imagesPerSec = (double)t0s.size() * 1000.0 / (double)(System.currentTimeMillis() - (Long)t0s.get(0));
                double etaSec = (double)(n - count) / imagesPerSec;
                String etaStr = "";
                if (count > 3) {
                    Datum eta = DatumUtil.asOrderOneUnits((Datum)Units.seconds.createDatum(etaSec));
                    FormatStringFormatter df = new FormatStringFormatter("%.1f", true);
                    etaStr = String.format(Locale.US, ", eta %s", df.format(eta));
                }
                if (imagesPerSec < 1.0) {
                    mon.setAdditionalInfo(String.format(Locale.US, "(%.1f/min%s)", imagesPerSec * 60.0, etaStr));
                } else {
                    mon.setAdditionalInfo(String.format(Locale.US, "(%.1f/sec%s)", imagesPerSec, etaStr));
                }
                if (outTemp.delete()) continue;
                logger.log(Level.WARNING, "unable to delete {0}", outTemp);
            } while (times.hasNext());
            if (!mon.isCancelled()) {
                CreatePngWalk.writeHTMLFile(params, pngFilenameArrayThumbs, pngFilenameArrayBig, timeLabels);
            }
        }
        finally {
            if (!mon.isFinished()) {
                mon.finished();
            }
        }
        return returnCodeAll;
    }

    private static String getFilename(Params params, String thumbdir, String atime) throws IllegalArgumentException {
        String filename;
        if (thumbdir.length() > 0 && !thumbdir.endsWith("/")) {
            thumbdir = thumbdir + "/";
        }
        if (params.useBatchUri && params.batchUriName.equals("$o")) {
            String name = atime;
            String outputFormat = params.outputFormat;
            if (name.toLowerCase().endsWith(params.outputFormat)) {
                outputFormat = name.substring(name.length() - outputFormat.length());
                name = name.substring(0, name.length() - (params.outputFormat.length() + 1));
            }
            filename = String.format("%s%s%s.%s", params.outputFolder, thumbdir, name, outputFormat);
        } else {
            if (params.useBatchUri && !params.batchUriName.equals("")) {
                throw new IllegalArgumentException("batchUriName must be \"\" or \"$o\"");
            }
            String vers = params.version == null || params.version.trim().length() == 0 ? "" : "_" + params.version.trim();
            filename = String.format("%s%s%s_%s%s.%s", params.outputFolder, thumbdir, params.product, atime, vers, params.outputFormat);
        }
        return filename;
    }

    private static String getRelativeFilename(Params params, String thumbdir, String atime) throws IllegalArgumentException {
        String filename;
        if (thumbdir.length() > 0 && !thumbdir.endsWith("/")) {
            thumbdir = thumbdir + "/";
        }
        if (params.useBatchUri && params.batchUriName.equals("$o")) {
            String name = atime;
            String outputFormat = params.outputFormat;
            if (name.toLowerCase().endsWith(params.outputFormat)) {
                outputFormat = name.substring(name.length() - outputFormat.length());
                name = name.substring(0, name.length() - (params.outputFormat.length() + 1));
            }
            filename = String.format("%s%s.%s", thumbdir, name, outputFormat);
        } else {
            if (params.useBatchUri && !params.batchUriName.equals("")) {
                throw new IllegalArgumentException("batchUriName must be \"\" or \"$o\"");
            }
            String vers = params.version == null || params.version.trim().length() == 0 ? "" : "_" + params.version.trim();
            filename = String.format("%s%s_%s%s.%s", thumbdir, params.product, atime, vers, params.outputFormat);
        }
        return filename;
    }

    public static int doIt(Application dom, Params params) throws ParseException, IOException, InterruptedException {
        ScriptContext2023 sc;
        int status = 0;
        final Window w = dom.getController() != null ? ((sc = dom.getController().getScriptContext()) != null ? sc.getViewWindow() : null) : null;
        if (params == null) {
            CreatePngWalkDialog p = new CreatePngWalkDialog();
            if (AutoplotUtil.showConfirmDialog(w, p, "Create PngWalk Options", 2) == 0) {
                TimeParser tp;
                NullProgressMonitor mon;
                p.writeDefaults();
                params = p.getParams();
                File ff = new File(params.outputFolder);
                if (p.getOverwriteCb().isSelected() && ff.exists()) {
                    FileUtil.deleteFileTree((File)ff);
                }
                if (w == null) {
                    mon = new NullProgressMonitor();
                    System.err.println("Can't find a GUI window, running quietly in the background.");
                } else {
                    mon = DasProgressPanel.createFramed((Window)w, (String)"running batch");
                }
                if (params.timeFormat.length() > 0 && !(tp = TimeParser.create((String)params.timeFormat)).isNested()) {
                    JOptionPane.showMessageDialog(w, "<html>Time spec must have fields nested: $Y,$m,$d, etc,<br>not " + params.timeFormat + " .");
                    return -1;
                }
                String[] times = CreatePngWalk.getListOfTimes(params, new ArrayList<String>());
                status = CreatePngWalk.doBatch(times, dom, params, (ProgressMonitor)mon);
                if (!mon.isCancelled()) {
                    String url = new File(params.outputFolder).toURI().toString();
                    if (w != null && params.outputFormat.equals("png")) {
                        logger.log(Level.FINE, "version=\"{0}\"", String.valueOf(params.version));
                        String vers = params.version == null || params.version.trim().length() == 0 ? "" : "_" + params.version.trim();
                        String st1 = params.batchUriName.length() == 0 ? url + params.product + "_" + params.timeFormat + vers + ".png" : url + "*.png";
                        final String st = st1;
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                PngWalkTool.start(st, w);
                            }
                        });
                    } else if (w != null) {
                        String vers = params.version == null || params.version.trim().length() == 0 ? "" : "_" + params.version.trim();
                        String st = url + params.product + "_" + params.timeFormat + vers + "." + params.outputFormat;
                        JOptionPane.showMessageDialog(w, "<html>Files created:<br>" + st);
                    }
                }
            }
        } else {
            String[] times = CreatePngWalk.getListOfTimes(params, new ArrayList<String>());
            Object mon = w == null ? ("true".equals(System.getProperty("java.awt.headless", "false")) ? new NullProgressMonitor() : DasProgressPanel.createFramed((String)"running batch")) : DasProgressPanel.createFramed((Window)w, (String)"running batch");
            status = CreatePngWalk.doBatch(times, dom, params, (ProgressMonitor)mon);
        }
        return status;
    }

    public static void writeHTMLFile(Params params, ArrayList<String> pngFilenameArrayThumbs, ArrayList<String> pngFilenameArrayBig, ArrayList<String> timeLabels) {
        if (params.update || timeLabels.size() != pngFilenameArrayBig.size()) {
            logger.info("skipping create HTML step because of partial run");
            return;
        }
        String filePath = params.outputFolder + "" + params.product + ".html";
        File f = new File(filePath);
        String htmlOpen = "<html>\n";
        String htmlHead = "\t<head><title>PNG Gallery " + params.product + "</title></head>\n";
        String htmlBody = "\t<body style=\"background-color: #6B6B6B; margin:0;\">\n";
        String htmlClose1 = "\t\t</div>\n";
        String htmlClose2 = "\t</body>\n";
        String htmlClose3 = "</html>";
        String pageHeaderOpen = "\t\t<div style=\"padding:20px; top: 0px; margin-right:0px; background-color:black; color:white;height:30px;\">\n\t\t\t<strong>PNG WALK</strong>\n\t\t</div>\n";
        String htmlAnchorStringOpen = "\t\t\t\t<a href=\"";
        String htmlAnchorStringClose = "\">\n";
        String htmlImageStringOpen = "\t\t\t\t<img src=\"";
        String htmlImageStringClose = "\" style=\"width:72px;height:68px;margin-left:10px;margin-bottom:10px;\"></a>\n";
        String htmlImageCaptionOpen = "\t\t\t\t<figcaption style=\"color: white; text-align:center;\">";
        String htmlImageCaptionClose = "\t\t\t\t</figcaption>\n";
        String htmlImageContainer = "\t\t<div style=\"background-color: #6B6B6B;margin-left:20px;\">\n";
        String htmlFigureOpen = "\t\t\t<figure style=\"width:78px; float:left;\">\n";
        String htmlFigureClose = "\t\t\t</figure>\n";
        int count = 0;
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(f));){
            bw.write(htmlOpen);
            bw.write(htmlHead);
            bw.write(htmlBody);
            bw.write(pageHeaderOpen);
            bw.write(htmlImageContainer);
            Iterator<String> iterator = pngFilenameArrayThumbs.iterator();
            while (iterator.hasNext()) {
                String pngFilenameArray1;
                String currentPngFilename = pngFilenameArray1 = iterator.next();
                String currentPngFilenameBIG = pngFilenameArrayBig.get(count);
                String fileNameToDisplay = timeLabels.get(count);
                ++count;
                String bigImageLink = htmlAnchorStringOpen + currentPngFilenameBIG + htmlAnchorStringClose;
                String addImageString = htmlImageStringOpen + currentPngFilename + htmlImageStringClose;
                String fullImageCaption = htmlImageCaptionOpen + fileNameToDisplay + htmlImageCaptionClose;
                bw.write(htmlFigureOpen);
                bw.write(bigImageLink);
                bw.write(addImageString);
                bw.write(fullImageCaption);
                bw.write(htmlFigureClose);
            }
            bw.write(htmlClose1);
            bw.write(htmlClose2);
            bw.write(htmlClose3);
        }
        catch (IOException e) {
            logger.log(Level.WARNING, e.getMessage(), e);
        }
    }

    public static void main(String[] args) throws InterruptedException, ParseException, IOException {
        Application dom;
        System.err.println("CreatePngWalk 20200819");
        ArgumentList alm = new ArgumentList("CreatePngWalk");
        alm.addOptionalSwitchArgument("timeFormat", "f", "timeFormat", "$Y$m$d", "timeformat for png files, e.g. $Y is year, $j is day of year");
        alm.addOptionalSwitchArgument("timeRange", "r", "timeRange", "", "time range to cover, e.g. 2011 through 2012");
        alm.requireOneOf(new String[]{"timeRange", "batchUri"});
        alm.addOptionalSwitchArgument("batchUri", "b", "batchUri", "", "optionally provide list of timeranges");
        alm.addOptionalSwitchArgument("batchUriName", null, "batchUriName", "", "use $o to use the filename in the batch file");
        alm.addOptionalSwitchArgument("createThumbs", "t", "createThumbs", "y", "create thumbnails, y (default) or n");
        alm.addOptionalSwitchArgument("product", "n", "product", "product", "product name in each filename (default=product)");
        alm.addOptionalSwitchArgument("outputFolder", "o", "outputFolder", "pngwalk", "location of root of pngwalk");
        alm.addOptionalSwitchArgument("outputFormat", null, "outputFormat", "png", "output format png or pdf");
        alm.addOptionalSwitchArgument("vap", "v", "vap", null, "vap file to plot");
        alm.addOptionalSwitchArgument("uri", "u", "uri", null, "single URI plotted");
        alm.requireOneOf(new String[]{"vap", "uri"});
        alm.addOptionalSwitchArgument("rescalex", null, "rescalex", "0%,100%", "rescale factor, such as '0%-1hr,100%+1hr', to provide context to each image");
        alm.addOptionalSwitchArgument("version", null, "version", null, "additional version string to add to each filename, like v1.0");
        alm.addBooleanSwitchArgument("autorange", null, "autorange", "rerange dependent dimensions Y and Z");
        alm.addBooleanSwitchArgument("autorangeFlags", null, "autorangeFlags", "only autorange axes with autorange=true");
        alm.addBooleanSwitchArgument("update", null, "update", "only calculate missing images");
        alm.addBooleanSwitchArgument("removeNoData", null, "removeNoData", "don't produce images which have no visible data.");
        alm.addBooleanSwitchArgument("testException", null, "testException", "throw a runtime exception to test exit code");
        if (!alm.process(args)) {
            System.exit(alm.getExitCode());
        }
        if (alm.getBooleanValue("testException")) {
            throw new RuntimeException("--textException on command line, throwing exception");
        }
        if (System.getProperty("noCheckCertificate", "true").equals("true")) {
            logger.fine("disabling HTTP certificate checks.");
            try {
                TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return new X509Certificate[0];
                    }

                    @Override
                    public void checkClientTrusted(X509Certificate[] certs, String authType) {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] certs, String authType) {
                    }
                }};
                SSLContext sc = SSLContext.getInstance("SSL");
                sc.init(null, trustAllCerts, new SecureRandom());
                HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
                HostnameVerifier allHostsValid = new HostnameVerifier(){

                    @Override
                    public boolean verify(String hostname, SSLSession session) {
                        return true;
                    }
                };
                HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
            }
            catch (KeyManagementException | NoSuchAlgorithmException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
        Params params = new Params();
        params.createThumbs = alm.getValue("createThumbs").equals("y");
        params.outputFolder = alm.getValue("outputFolder");
        params.product = alm.getValue("product");
        params.timeFormat = alm.getValue("timeFormat");
        params.timeRangeStr = alm.getValue("timeRange");
        params.rescalex = alm.getValue("rescalex");
        params.version = alm.getValue("version");
        params.autorange = alm.getBooleanValue("autorange");
        params.autorangeFlags = alm.getBooleanValue("autorangeFlags");
        params.update = alm.getBooleanValue("update");
        params.batchUri = alm.getValue("batchUri");
        params.removeNoData = alm.getBooleanValue("removeNoData");
        if (params.batchUri != null && params.batchUri.length() > 0) {
            params.useBatchUri = true;
            params.batchUriName = alm.getValue("batchUriName");
        }
        params.outputFormat = alm.getValue("outputFormat");
        String vap = alm.getValue("vap");
        if (vap != null) {
            if (vap.length() > 2 && vap.charAt(1) == ':') {
                logger.fine("reference appears to be absolute (Windows)");
            } else {
                vap = URISplit.makeAbsolute((String)new File(".").getAbsolutePath(), (String)vap);
            }
            File f = DataSetURI.getFile((String)vap);
            dom = (Application)StatePersistence.restoreState(f);
        } else {
            String uri = alm.getValue("uri");
            ScriptContext.setCanvasSize(800, 600);
            ScriptContext.plot(uri);
            dom = ScriptContext.getDocumentModel();
        }
        if (vap != null && vap.contains(params.outputFolder)) {
            params.writeVap = false;
        }
        int status = CreatePngWalk.doIt(dom, params);
        System.exit(status);
    }

    public static class Params {
        public String outputFolder = null;
        public String timeRangeStr = null;
        public String rescalex = "0%,100%";
        public boolean autorange = true;
        public boolean autorangeFlags = true;
        public boolean runOnCopy = true;
        public String version = null;
        public String product = null;
        public String timeFormat = null;
        public String batchUri = null;
        public boolean useBatchUri = false;
        public String batchUriName = "";
        public boolean createThumbs = true;
        public boolean update = false;
        public String outputFormat = "png";
        public boolean writeVap = true;
        public boolean removeNoData = false;

        public String toString() {
            return String.format("outputFolder=%s\ntimeRange=%s\nrescalex=%s\nautorange=%s\nversion=%s\nproduct=%s\ntimeFormat=%s\ncreateThumbs=%s\nupdate=%s\n", this.outputFolder, this.timeRangeStr, this.rescalex, this.autorange, this.version, this.product, this.timeFormat, this.createThumbs, this.update);
        }
    }
}

